.TH play n "Version 3.8.5" "Tina Tools"

.SH NAME
play  \- Tina stepper simulator

Part of Tina Toolbox for analysis of Petri nets and Time Petri nets.


.SH SYNOPSIS

.B play [\-\f2h\f1elp]
     [\-NET | \-NDR | \-TPN | \-PNML | \-TTS]
     [\-seed] [\-inh] [\-tc] [\-dt] [\-pr] [\-sw]
     [infile] [outfile] [errorfile]


.SH DESCRIPTION

Tool  play allows  to  simulate  net descriptions  in  any of  formats
\&.net,  \&.ndr,  \&.tpn, \&.pnml  or  \&.tts.   Its capabilities  are
similar to those provided by the  nd stepper except that play may also
simulate \&.tts descriptions.

A simulation  is a  series of states  separated by  transitions (delay
transitions or  discrete transitions). Play  allows one to  build such
sequences and navigate within, interactively.


.SH OPTIONS

.TP
\-\f2h\f1elp
Recalls options.


.TP
.B Verbosity level:

.TP
\-v
Prints banner, parsing message and prompts for commands (default).

.TP
\-q 
No banner nor times are printed. This flag is convenient for batch usage of play.

.TP
.B Exploration strategy options:

.TP
\-seed
Initializes the random number generator so that different calls of play on the same arguments
have a chance to explore different paths (if any).

.TP
.B Input options:

.TP
\-inh
Forget inhibitor and read arcs in the input net.

.TP
\-pr
Forget priority constraints in the input net.

.TP
\-tc
Forget time constraints  in the input net.

.TP
\-dt
Forget data processing when reading a tts description.

.TP
\-sw
Forget stopwatches in the input net.


.TP
.B Input format and source:

.TP
\-NET | -NDR | -PNML | -TPN | -TTS
Specifies the format of the input net. This flag is necessary when the
input net is read on standard input, or read from a file that does not
bear the expected extension. By default, the net is assumed in .net or
.ndr format.

.TP
infile
Where the  net is  read. The  input format is  determined by  the file
type, according to the table below. If absent or specified by "-", the
net is  read on standard  input in the  format specified by  the input
flag. If  both an  infile and  some input flag  are present,  then the
format defined  by the  input flag supersedes  that determined  by the
infile extension.

.nf
file extension		input format
--------------------------------------------------------------
\&.net			net format
\&.ndr			ndr format
\&.tpn			tpn format
\&.pnml			pnml format
\&.tts			tts format
.fi


.TP
.B Output destination:

.TP
outfile
Where results are written. If absent or specified  by "-",
results are written on standard output.


.TP
.B Errors destination:

.TP
errorfile
Where error messages are written. If absent or specified  by "-",
error messages are written on standard error.



.SH PLAY STEPPER INTERACTIVE COMMANDS

When  called, play prints  the initial  state of  the input  net, with
information about  the enabled,  frozen and firable  transitions, then
waits for commands. These commands are the following.

.TP
.B h
Prints a short summary of available commands.

.TP
.B f tr
Fires transition with name tr. tr must be among the transitions shown as firable.

.TP
.B # n
Fires the n^th transition in the firable list of transitions.

.TP
.B d k
Let delay k elapse from current state, k is an integer of a number in
floating point notation.

.TP
.B r n
Randomly fire n random steps and print last state reached.
A step is delay followed by a discrete transition.

.TP
.B R n
Like "r n" except intermediate states are printed.

.TP
.B m
Sets a mark on the current state (for commands << and >> below).

.TP
.B < [n]
Undoes [n times] in history the last state transition (delay or discrete). Default n is 1.

.TP
.B > [n]
Redoes [n times] in history the next state transition (delay or discrete). Default n is 1.
Redo n is only possible if at least n state transitions are available in the history,
that is if some undo have been done before.

.TP
.B << [n]
Jump backward [n times] in history to the previously marked state or the initial state.

.TP
.B >> [n]
Jump forward [n times] in history to the next marked state or the last state.

.TP
.B |<
Jump to the initial state.

.TP
.B >|
Jump to the last state stored.

.TP
.B .
Prints the current state.

.TP
.B l file
Load a scenario file in \&.scn format generated by selt, pathto, plan or play.
If the input net is timed, then the \&.scn file must be timed too.

.TP
.B s file
Save the current history as a \&.scn file. If the input net is timed, then the
\&.scn will be timed too.

.TP
.B k (true|false)
Keep history (default) or not when applying commands f, d, r or R. Not keeping
history permits long simulations that could otherwise exhaust memory. 
Navigation commands (<, >, <<, >>, |<, |>, m) are only available when history
is kept.

.TP
.B q or ^D
Quit play.



.SH EXAMPLES

.nf
play ifip.ndr
play abp.ndr -q < commands > results
.fi


.SH SEE ALSO

nd(n), tina(n), plan(n), struct(n), ktzio(n), ndrio(n), tedd(n), selt(n), sift(n), muse(n), pathto(n), scan(n), walk(n), reduce(n), formats(n)

.SH AUTHORS
Bernard Berthomieu
LAAS/CNRS,  2000-2024, Bernard.Berthomieu@laas.fr

