#include "config.def"

////////////////////////////////////////////////////////////////////////////////

// static const int DYN_Q = 100;
// static const int DYN_S = 100;

int dyntable[2] = {
	4, // "eq1_1_t0"
	5, // "eq2_1_t0"
};

int *dyntransitions (int *sz) {
	*sz =2; 
	return dyntable;
}

int dyn_nwbl_4(key s) {
	struct value new = *(struct value*)lookup(s);

	/* eq1_1_t0 */
	int df = fcr_f1(new.Main_1_vx1, new.Main_1_vx2);
	if (df == 0)
		return (-1); /* impossible because of guard on (fcr_f1(x, y) <> 0) */
	else
		return fcr_abs(DYN_Q * DYN_S / df);
}

int dyn_prst_4(key s, int alpha) {
	struct value new = *(struct value*)lookup(s);

	/* eq1_1_t0 */
	int dfold = fcr_f1(new.Main_1_vx1,new.Main_1_vx2 - DYN_Q * new.Main_1_vsgnx2);
	int dfnew = fcr_f1(new.Main_1_vx1,new.Main_1_vx2);
  
	if (dfnew == 0) 
		return (-1); /* impossible because we added condition on independent transitions */
	else 
		return (dfold * alpha) / dfnew;
}

int dyn_nwbl_5(key s) {
	struct value new = *(struct value*)lookup(s);
  
	/* eq2_1_t0 */
	int df = fcr_f2(new.Main_1_vx2,new.Main_1_vx1);

	if (df == 0)
		return (-1);
	else
		return fcr_abs(DYN_Q * DYN_S / df);
}

int dyn_prst_5(key s, int alpha) {
	struct value new = *(struct value*)lookup(s);
	
	/* eq2_1_t0 */
	int dfold = fcr_f2(new.Main_1_vx2,new.Main_1_vx1 - DYN_Q * new.Main_1_vsgnx1);
	int dfnew = fcr_f2(new.Main_1_vx2,new.Main_1_vx1);
	
	if (dfnew == 0) 
		return (-1);
	else 
		return (dfold * alpha) / dfnew;
}
