#!/usr/bin/python

import re
import matplotlib.pyplot as plt

DEBUG=False

def dprint(s):
    if DEBUG:
        print(s)
        
source = "out.tina"

RG_RE=re.compile(r'REACHABILITY GRAPH:\n')
ST_RE=re.compile(r'(?P<num>\d+) -> (?P<succs>.*)\n')
SUCC_RE=re.compile(r'(?P<trans>[a-zA-Z_0-9]+) in \[(?P<t1>\d+),(?P<t2>\d+)\]/(?P<succ>\d+)')
CLS_RE=re.compile(r'(?P<state>[a-zA-Z_0-9]+) {(?P<vn1>[a-zA-Z_0-9]+)=(?P<vv1>-*\d+),(?P<vn2>[a-zA-Z_0-9]+)=(?P<vv2>-*\d+),(?P<vn3>[a-zA-Z_0-9]+)=(?P<vv3>-*\d+),(?P<vn4>[a-zA-Z_0-9]+)=(?P<vv4>-*\d+)}\n')

from collections import defaultdict

classes = {}
graph = defaultdict(list)
dates = defaultdict(lambda : -1)
state_num = 0
f = open(source)
for line in f:
    res = CLS_RE.search(line)    
    if res:
        dprint(line)
        state = res.group('state')
        var = {}
        for i in range(1, 4):
            vn   = res.group('vn' + str(i))
            vv   = res.group('vv' + str(i))
            var[vn] = vv
        classes[state_num] = (state, var)
        state_num += 1
    res = ST_RE.search(line)
    if res:
        dprint(line)
        num = int(res.group('num'))
        succs = res.group('succs').split(', ')
        for succ in succs:
            res = SUCC_RE.search(succ)
            if res:                
                trans = res.group('trans')
                t1    = int(res.group('t1'))
                t2    = int(res.group('t2'))
                succ  = int(res.group('succ'))
                graph[num].append( (trans, t1, t2, succ) )

import sys, random
sys.setrecursionlimit(15000)

traces = []

def random_trace(trace, state, time):    
    if time > 3100:       
        return trace
    else:
        if not graph[state]:
            return trace
        (trans, t1, t2, succ) = random.choice(graph[state])
        next_time = time + t1
        if (t1 != 0):        
            new_trace = trace + [(succ,next_time)]
        else:
            new_trace = trace

        if succ:
            return random_trace(new_trace, succ, next_time)
        else:
            return trace

while len(traces) < 500:
    traces.append(random_trace([(0,0)], 0, 0))

print(len(traces))

num = 0
d0 = []
d1 = []
for i,trace in enumerate(traces):
    d0.append([])
    d1.append([])
    for (state, date) in trace:
        (_, var) = classes[state]  
        d0[i].append(date)
        d1[i].append(var['Main_1_vx1'])
        dprint ("{}, {}".format(date, var['Main_1_vx1']))

for i in range(len(d0)):
    plt.step(d0[i], d1[i])
    
plt.show()
