#!/usr/bin/python

import re
import matplotlib.pyplot as plt

DEBUG=False

def dprint(s):
    if DEBUG:
        print(s)
        
source = "out.tina"

RG_RE=re.compile(r'REACHABILITY GRAPH:\n')
ST_RE=re.compile(r'(?P<num>\d+) -> (?P<trans>[a-zA-Z_0-9]+) in \[(?P<t1>\d+),(?P<t2>\d+)\]/(?P<succ>\d+)\n')
CLS_RE=re.compile(r'(?P<state>[a-zA-Z_0-9]+) {(?P<vn1>[a-zA-Z_0-9]+)=(?P<vv1>-*\d+),(?P<vn2>[a-zA-Z_0-9]+)=(?P<vv2>-*\d+)}\n')

classes = {}
graph = {}
num = 0
f = open(source)
for line in f:
    res = CLS_RE.search(line)    
    if res:
        dprint(line)
        state = res.group('state')
        var = {}
        for i in range(1, 3):
            vn   = res.group('vn' + str(i))
            vv   = res.group('vv' + str(i))
            var[vn] = vv
        classes[num] = (state, var)
        num += 1
    res = ST_RE.search(line)
    if res:
        dprint(line)
        num   = int(res.group('num'))
        trans = res.group('trans')
        t1    = int(res.group('t1'))
        t2    = int(res.group('t2'))
        succ  = int(res.group('succ'))
        
        graph[num] = (trans, t1, t2, succ)

date = 0
num = 0
d0 = []
d1 = []
try:
    while num >= 0:
        (trans, t1, t2, succ) = graph[num]
        (_, var) = classes[num]    
        try:
            d1.append(d1[-1])
            d0.append(date-1)
        except:
            pass
        d0.append(date)
        d1.append(var['Main_1_vx'])
        dprint("{}, {}".format(date, var['Main_1_vx']))
        date += t1
        num = succ
except:
    pass

import math

f = {}
e = []
expected = { x * 500 : False for x in range(0, 8) }
def E(v, i):
    for r in [ x * 500 for x in range(0, 8) ]:        
        if expected[r] == False and v <= r:
            expected[r] = i

for i in range(0,d0[-1]):
    v = 4000*math.exp(-i / (100.0*100.0))
    e.append(v)    
    f[i] = v
    E(v, i)

diff = 0
reach = { x * 500 : False for x in range(0, 8) }
def R(v, i):
    for r in [ x * 500 for x in range(0, 8) ]:
        if reach[r] == False and v <= r:
            reach[r] = i
for index, i in enumerate(d0):
    R(int(d1[index]), i)

    try:
        v = f[i]
        diff = max(diff, abs(int(d1[index]) - v))
        diff = max(diff, abs(int(d1[index+1]) - v))
    except:
        pass

print "DIFF = ", diff
for r in [ x * 500 for x in range(1, 8) ]:
    print("{} reached at {} (expected at {})".format(r, reach[r], expected[r]))

plt.step(d0, d1)
plt.plot(range(0,d0[-1]), e)
plt.show()
